<?php include('config/db.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $category_id = $_POST['category_id'];
    $name = $conn->real_escape_string($_POST['name']);
    $title = $conn->real_escape_string($_POST['title']);
    $description = $conn->real_escape_string($_POST['description']);
    $icon_url = $conn->real_escape_string($_POST['icon_url']);
    $feature_image_url = $conn->real_escape_string($_POST['feature_image_url']);

    $url_titles = $_POST['url_title'];
    $url_links = $_POST['url_link'];
    $urls = [];

    for ($i = 0; $i < count($url_titles); $i++) {
        if (!empty($url_titles[$i]) && !empty($url_links[$i])) {
            $urls[] = [
                'title' => $conn->real_escape_string($url_titles[$i]),
                'link' => $conn->real_escape_string($url_links[$i])
            ];
        }
    }

    $urls_json = json_encode($urls);

    $conn->query("INSERT INTO books (category_id, name, title, description, icon_url, feature_image_url, urls) 
                  VALUES ('$category_id', '$name', '$title', '$description', '$icon_url', '$feature_image_url', '$urls_json')");
    header("Location: books.php");
    exit;
}

$categories = $conn->query("SELECT * FROM categories");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Add Book</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <script>
    function addUrlField() {
        const container = document.getElementById('urlFields');
        const div = document.createElement('div');
        div.className = "row mb-2";
        div.innerHTML = `
            <div class="col-md-5">
                <input type="text" name="url_title[]" class="form-control" placeholder="URL Title" required>
            </div>
            <div class="col-md-5">
                <input type="text" name="url_link[]" class="form-control" placeholder="URL Link" required>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-danger" onclick="this.parentElement.parentElement.remove()">Remove</button>
            </div>
        `;
        container.appendChild(div);
    }
    </script>
</head>
<body>
<div class="container mt-4">
    <h2>Add New Book</h2>
    <form method="POST">
        <div class="mb-3">
            <label>Category</label>
            <select name="category_id" class="form-control" required>
                <?php while ($cat = $categories->fetch_assoc()) {
                    echo "<option value='{$cat['id']}'>{$cat['name']}</option>";
                } ?>
            </select>
        </div>
        <div class="mb-3">
            <label>Book Name</label>
            <input type="text" name="name" class="form-control" required />
        </div>
        <div class="mb-3">
            <label>Book Title</label>
            <input type="text" name="title" class="form-control" required />
        </div>
        <div class="mb-3">
            <label>Description</label>
            <textarea name="description" class="form-control" required></textarea>
        </div>
        <div class="mb-3">
            <label>Icon URL</label>
            <input type="text" name="icon_url" class="form-control" required />
        </div>
        <div class="mb-3">
            <label>Feature Image URL</label>
            <input type="text" name="feature_image_url" class="form-control" required />
        </div>

        <div class="mb-3">
            <label>Book URLs (Title + Link)</label>
            <div id="urlFields">
                <div class="row mb-2">
                    <div class="col-md-5">
                        <input type="text" name="url_title[]" class="form-control" placeholder="URL Title" required>
                    </div>
                    <div class="col-md-5">
                        <input type="text" name="url_link[]" class="form-control" placeholder="URL Link" required>
                    </div>
                    <div class="col-md-2">
                        <button type="button" class="btn btn-danger" onclick="this.parentElement.parentElement.remove()">Remove</button>
                    </div>
                </div>
            </div>
            <button type="button" class="btn btn-sm btn-info mt-2" onclick="addUrlField()">+ Add More</button>
        </div>

        <button class="btn btn-primary">Save</button>
        <a href="books.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>
</body>
</html>
