<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *"); // optional for public API
include('../config/db.php');

$result = $conn->query("SELECT * FROM categories ORDER BY id ASC");

$categories = [];
while ($row = $result->fetch_assoc()) {
    $categories[] = [
        "id" => $row['id'],
        "name" => $row['name'],
        "icon_url" => $row['icon_url']
    ];
}

echo json_encode([
    "status" => "success",
    "count" => count($categories),
    "categories" => $categories
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
