<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
include('../config/db.php');

// Fetch all categories
$category_result = $conn->query("SELECT * FROM categories ORDER BY id ASC");

$categories = [];

while ($cat = $category_result->fetch_assoc()) {
    $category_id = $cat['id'];
    $books_result = $conn->query("
        SELECT * FROM books 
        WHERE category_id = $category_id 
        ORDER BY id DESC 
        LIMIT 10
    ");

    $books = [];
    while ($book = $books_result->fetch_assoc()) {
        $books[] = [
            "id" => $book['id'],
            "name" => $book['name'],
            "title" => $book['title'],
            "description" => $book['description'],
            "icon_url" => $book['icon_url'],
            "feature_image_url" => $book['feature_image_url'],
            "urls" => json_decode($book['urls'], true)
        ];
    }

    $categories[] = [
        "id" => $cat['id'],
        "name" => $cat['name'],
        "icon_url" => $cat['icon_url'],
        "books" => $books
    ];
}

echo json_encode([
    "status" => "success",
    "category_count" => count($categories),
    "categories" => $categories
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
