<?php include('config/db.php'); ?>
<!DOCTYPE html>
<html>
<head>
    <title>Manage Books</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-4">
    <h2 class="mb-3">Books</h2>
    <a href="add_book.php" class="btn btn-success mb-3">Add Book</a>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th><th>Name</th><th>Title</th><th>Category</th><th>Icon</th><th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php
        $sql = "SELECT books.*, categories.name as category_name FROM books JOIN categories ON books.category_id = categories.id ORDER BY books.id DESC";
        $result = $conn->query($sql);
        while ($row = $result->fetch_assoc()) {
            echo "<tr>
                <td>{$row['id']}</td>
                <td>{$row['name']}</td>
                <td>{$row['title']}</td>
                <td>{$row['category_name']}</td>
                <td><img src='{$row['icon_url']}' width='40'></td>
                <td>
                    <a href='update_book.php?id={$row['id']}' class='btn btn-sm btn-primary'>Edit</a>
                    <a href='delete_book.php?id={$row['id']}' class='btn btn-sm btn-danger' onclick='return confirm(\"Are you sure?\")'>Delete</a>
                </td>
            </tr>";
        }
        ?>
        </tbody>
    </table>
</div>
</body>
</html>
