<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dashboard - Book Management</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .card {
            border-radius: 12px;
            transition: all 0.3s ease-in-out;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>📚 Book Management Dashboard</h2>
        <a href="logout.php" class="btn btn-outline-danger btn-sm">Logout</a>
    </div>

    <div class="row g-4">
        <div class="col-md-6">
            <a href="categories.php" style="text-decoration: none;">
                <div class="card text-center p-4 bg-white">
                    <h4 class="text-dark">📁 Manage Categories</h4>
                    <p class="text-muted mb-0">Add, edit or delete book categories</p>
                </div>
            </a>
        </div>
        <div class="col-md-6">
            <a href="books.php" style="text-decoration: none;">
                <div class="card text-center p-4 bg-white">
                    <h4 class="text-dark">📖 Manage Books</h4>
                    <p class="text-muted mb-0">Add, edit or delete books</p>
                </div>
            </a>
        </div>
    </div>
</div>
</body>
</html>
