<?php 
include('config/db.php');
$id = $_GET['id'];
$book = $conn->query("SELECT * FROM books WHERE id=$id")->fetch_assoc();
$categories = $conn->query("SELECT * FROM categories");
$urls = json_decode($book['urls'], true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $category_id = $_POST['category_id'];
    $name = $conn->real_escape_string($_POST['name']);
    $title = $conn->real_escape_string($_POST['title']);
    $description = $conn->real_escape_string($_POST['description']);
    $icon_url = $conn->real_escape_string($_POST['icon_url']);
    $feature_image_url = $conn->real_escape_string($_POST['feature_image_url']);

    $url_titles = $_POST['url_title'];
    $url_links = $_POST['url_link'];
    $url_data = [];

    for ($i = 0; $i < count($url_titles); $i++) {
        if (!empty($url_titles[$i]) && !empty($url_links[$i])) {
            $url_data[] = [
                'title' => $conn->real_escape_string($url_titles[$i]),
                'link' => $conn->real_escape_string($url_links[$i])
            ];
        }
    }

    $urls_json = json_encode($url_data);

    $conn->query("UPDATE books SET category_id='$category_id', name='$name', title='$title', description='$description', 
        icon_url='$icon_url', feature_image_url='$feature_image_url', urls='$urls_json' WHERE id=$id");

    header("Location: books.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Edit Book</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <script>
    function addUrlField(title = '', link = '') {
        const container = document.getElementById('urlFields');
        const div = document.createElement('div');
        div.className = "row mb-2";
        div.innerHTML = `
            <div class="col-md-5">
                <input type="text" name="url_title[]" class="form-control" placeholder="URL Title" value="${title}" required>
            </div>
            <div class="col-md-5">
                <input type="text" name="url_link[]" class="form-control" placeholder="URL Link" value="${link}" required>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-danger" onclick="this.parentElement.parentElement.remove()">Remove</button>
            </div>
        `;
        container.appendChild(div);
    }

    window.onload = function () {
        const urlData = <?= json_encode($urls); ?>;
        if (urlData.length > 0) {
            urlData.forEach(item => {
                addUrlField(item.title, item.link);
            });
        } else {
            addUrlField(); // at least one field
        }
    }
    </script>
</head>
<body>
<div class="container mt-4">
    <h2>Edit Book</h2>
    <form method="POST">
        <div class="mb-3">
            <label>Category</label>
            <select name="category_id" class="form-control" required>
                <?php while ($cat = $categories->fetch_assoc()) {
                    $selected = ($cat['id'] == $book['category_id']) ? "selected" : "";
                    echo "<option value='{$cat['id']}' $selected>{$cat['name']}</option>";
                } ?>
            </select>
        </div>
        <div class="mb-3">
            <label>Book Name</label>
            <input type="text" name="name" class="form-control" value="<?= $book['name'] ?>" required />
        </div>
        <div class="mb-3">
            <label>Book Title</label>
            <input type="text" name="title" class="form-control" value="<?= $book['title'] ?>" required />
        </div>
        <div class="mb-3">
            <label>Description</label>
            <textarea name="description" class="form-control" required><?= $book['description'] ?></textarea>
        </div>
        <div class="mb-3">
            <label>Icon URL</label>
            <input type="text" name="icon_url" class="form-control" value="<?= $book['icon_url'] ?>" required />
        </div>
        <div class="mb-3">
            <label>Feature Image URL</label>
            <input type="text" name="feature_image_url" class="form-control" value="<?= $book['feature_image_url'] ?>" required />
        </div>

        <div class="mb-3">
            <label>Book URLs (Title + Link)</label>
            <div id="urlFields"></div>
            <button type="button" class="btn btn-sm btn-info mt-2" onclick="addUrlField()">+ Add More</button>
        </div>

        <button class="btn btn-primary">Update</button>
        <a href="books.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>
</body>
</html>
